/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __CPUPORT_H
#define __CPUPORT_H


#include "cpupdefs.h"


#ifdef __cplusplus
extern "C" {
#endif
  
/* -----------------------------------------------------------------
 * CPU Port Programming Functions 
 * ----------------------------------------------------------------- */
CLI b_errtype EXPORT BestCPUportPropDefaultSet(  /* @cpuprpdefset */
                               b_handletype handle
			       );

CLI b_errtype EXPORT	BestCPUportPropSet(	/* @cpuprpset */
  				b_handletype   handle,
				b_cpuproptype  cpuprop,   	/* @prop */
				b_int32        value        	/* @val */
  			);


CLI b_errtype EXPORT	BestCPUportWrite( 	/* @cpuwrite */
		       	       b_handletype handle,
			       b_int32      device_num,       	/* @dev  */
			       b_int32      address,          	/* @ad */
			       b_int32      data,             	/* @val */
			       b_sizetype   size              	/* @size */
		   	);


CLI b_errtype EXPORT	BestCPUportRead( 	/* @cpuread */
			 	b_handletype handle,
				b_int32      device_num, 	/* @dev */
				b_int32      address,     	/* @ad */
				b_int32 *    data_ptr,    	/* #RETURN "data =: %x\\h\n" */
				b_sizetype   size         	/* @size */
			);



CLI b_errtype EXPORT	BestCPUportWordBlockWrite(	/* @cpuwbwrite */
			  	b_handletype handle,
				b_int32      device_num, 	/* @dev  */
				b_int32      address,    	/* @ad */
				b_int16 HUGE * data_ptr,   	/* @data */
				b_int32      num_of_bytes	/* @nob */
		    	);


/* BestCPUportWordBlockRead: This function is not covered by CLI
 because it does not adhere to CLI standards: please look in
 manualcli.h */
b_errtype EXPORT 	BestCPUportWordBlockRead(  	/* @cpuwbread */
			   	b_handletype handle,
				b_int32      device_num,	/* @dev */
				b_int32      address,     	/* @ad */
				b_int16 HUGE * data_ptr,    	/* @data */
				b_int32      num_of_bytes 	/* @nob */
		   	);
CLI b_errtype EXPORT	BestCPUportIntrStatusGet(	/* @cpuistatget */
		      		b_handletype handle,
				b_int32      *intvalue_ptr 	/* #RETURN "value =: %x\\h\n" */
	   		);


CLI b_errtype EXPORT 	BestCPUportIntrClear(       	/* @cpuintclear */
			    	b_handletype handle
	 		);


CLI b_errtype EXPORT  	BestCPUportRST (     		/* @cpurst */
			   	b_handletype handle,
				b_int32      value            	/* @val */
  			);

/* -----------------------------------------------------------------
 * Static IO Port Programming Functions 
 * ----------------------------------------------------------------- */

CLI b_errtype EXPORT BestStaticPropDefaultSet(  /* @sprpdefset */
                               b_handletype handle
			       );

CLI b_errtype EXPORT BestStaticPropSet(                               /* @sprpset */
				       b_handletype     handle,
				       b_int32          pin_num,      /* @pin */
				       b_staticproptype staticprop,   /* @prop */
				       b_int32          value         /* @val */
				       );


CLI b_errtype EXPORT BestStaticPropGet( 			/* @sprpget */
                                    b_handletype handle,
				    b_int32 pin_num,		/* @pin */
				    b_staticproptype staticprop,/* @prop */
				    b_int32 * value 		/* #RETURN "Sideband Prop =: %ld\n" */
  );
				    
CLI b_errtype EXPORT BestStaticWrite(                         	/* @swrite */
  b_handletype handle,
  b_int32      value        /* @val */
				     );


CLI b_errtype EXPORT BestStaticRead(                          	/* @sread */
				    b_handletype handle,
				    b_int32 *    value         /* #RETURN "Sideband Port=: %x\\h\n" */
				    );


CLI b_errtype EXPORT BestStaticPinWrite(                             /* @spwrite */
					b_handletype   handle,
					b_int32        pin_num,      /* @pin */
					b_int32        value         /* @val */
					);



#ifdef __cplusplus
}
#endif


#endif






